import datetime
from termcolor import colored

def log_message(message):
    """
    Logs a message without weight to a file.

    Args:
        message (str): The logging message.

    """

    print(colored(message, "white"))


def log_info(message):
    """
    Logs a message with the weight [INFO] to a file.

    Args:
        message (str): The logging message.
    """
    n = datetime.datetime.now()
    f = f"[" + n.strftime("%d.%m.%Y - %H:%M:%S") + "] [INFO] " + message
    print(colored(f"[" + n.strftime("%d.%m.%Y - %H:%M:%S") + "]", "cyan"), colored("[INFO] ", "green"), message)

def log_warn(message):
    """
    Logs a message with the weight [WARN] to a file.

    Args:
        message (str): The logging message.
    """

    n = datetime.datetime.now()
    f = f"[" + n.strftime("%d.%m.%Y - %H:%M:%S") + "] [WARN] " + message
    print(colored(f"[" + n.strftime("%d.%m.%Y - %H:%M:%S") + "]", "cyan"), colored(f"[WARN] {message}", "yellow"))


def log_error(message):
    """
    Logs a message with the weight [ERROR] to a file.

    Args:
        message (str): The logging message.
    """
    n = datetime.datetime.now()
    f = f"[" + n.strftime("%d.%m.%Y - %H:%M:%S") + "] [ERROR] " + message
    print(colored(f"[" + n.strftime("%d.%m.%Y - %H:%M:%S") + "]", "cyan"), colored(f"[ERROR] {message}", "red"))

def log_fatal_error(message):
    """
    Logs a message with the weight [FATAL ERROR] to a file.

    Args:
        message (str): The logging message.
    """
    n = datetime.datetime.now()
    print(colored(f"[" + n.strftime("%d.%m.%Y - %H:%M:%S") + "]", "cyan"), colored(f"[FATAL ERROR] {message}", "red"))