import os
import subprocess
import uuid
import json
import shutil
from PIL import Image
from PIL import ImageTk
from tkinter import messagebox, filedialog
import customtkinter as ctk
import tkinter as tk
from CTkMessagebox import CTkMessagebox
from m_log import *

logo = [
    "██████╗  ██████╗  ██████╗ ███╗   ███╗                              ",
    "██╔══██╗██╔═══██╗██╔═══██╗████╗ ████║                              ",
    "██║  ██║██║   ██║██║   ██║██╔████╔██║                              ",
    "██║  ██║██║   ██║██║   ██║██║╚██╔╝██║                              ",
    "██████╔╝╚██████╔╝╚██████╔╝██║ ╚═╝ ██║                              ",
    "╚═════╝  ╚═════╝  ╚═════╝ ╚═╝     ╚═╝                              ",
    "                                                                   ",
    "██╗      █████╗ ██╗   ██╗███╗   ██╗ ██████╗██╗  ██╗███████╗██████╗ ",
    "██║     ██╔══██╗██║   ██║████╗  ██║██╔════╝██║  ██║██╔════╝██╔══██╗",
    "██║     ███████║██║   ██║██╔██╗ ██║██║     ███████║█████╗  ██████╔╝",
    "██║     ██╔══██║██║   ██║██║╚██╗██║██║     ██╔══██║██╔══╝  ██╔══██╗",
    "███████╗██║  ██║╚██████╔╝██║ ╚████║╚██████╗██║  ██║███████╗██║  ██║",
    "╚══════╝╚═╝  ╚═╝ ╚═════╝ ╚═╝  ╚═══╝ ╚═════╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝"
]

for line in logo:
    log_info(line)


log_info("Starting Launcher")

log_info("Initialize data format...")

WAD_PATH = None

CONFIG_FILE = "dat_/instances.json"


GZDOOM_PATH = "ext_\lib\dependencies\gzdoom-4-14-0a-windows\gzdoom.exe"
WAD_DIR = "dat_/gamedata/wads"
SAVE_DIR = "dat_/gamedata/saves"

log_info("Initialize data format... - DONE")




def lade_instanzen():
    try:
        if os.path.exists(CONFIG_FILE):
            with open(CONFIG_FILE, "r") as file:
                log_info("[FILESYSTEM] Config database was read.")

                return json.load(file)
        log_error("[FILESYSTEM] Config database could not be read because an error occurred.")
        
        return {}
    except:
        log_error("[FILESYSTEM] Config database could not be read because an error occurred.")

        return {}


def speichere_instanz(name, wad_path, save_dir):
    try:
        instanzen = lade_instanzen()
        instanzen[name] = {"wad": wad_path, "save": save_dir}
        with open(CONFIG_FILE, "w") as file:
            log_info("[FILESYSTEM] Config database has been changed.")

            json.dump(instanzen, file, indent=4)
    except:
        log_error("[FILESYSTEM] Config database could not be changed because an error occurred.")

def pop_instanz(name):
    try:
        instanzen = lade_instanzen()
        instanzen.pop(name)
        with open(CONFIG_FILE, "w") as file:
            log_info("[FILESYSTEM] Config database has been changed.")
            
            json.dump(instanzen, file, indent=4)
    except:
        log_error("[FILESYSTEM] Config database could not be changed because an error occurred.")


def starte_doom(instanz):

    msg = CTkMessagebox(title="Spiel Starten?",
                        message="Wenn du das Spiel startest wird Ton abgespielt und du musst zwangsweise Alt+F4 drücken, um dieses Spiel zu verlassen. Willst du fortfahren?",
                        icon="warning", option_1="Abbrechen", option_2="Starten")

    if msg.get() == "Starten":

        instanzen = lade_instanzen()
        if instanz not in instanzen:
            messagebox.showerror("Fehler", "Instanz nicht gefunden!")
            return

        wad_path = instanzen[instanz]["wad"]
        save_dir = instanzen[instanz]["save"]

        if not os.path.isfile(GZDOOM_PATH):
            messagebox.showerror("Fehler", "GZDoom nicht gefunden!")
            return
        if not os.path.isfile(wad_path):
            messagebox.showerror("Fehler", "WAD-Datei nicht gefunden!")
            return
        log_info("[GAME] Using a new thread to run the instance")
        
        subprocess.run([GZDOOM_PATH, "-iwad", wad_path, "+set", "fullscreen", "0", "+set", "save_dir", save_dir])

class MainApp(ctk.CTk):
    def __init__(self):
        super().__init__()
        self.title("DOOM Launcher")
        self.geometry("600x400")
        self.iconpath = ImageTk.PhotoImage(file="ext_/src/img/favicon.png")
        self.wm_iconbitmap()
        self.iconphoto(False, self.iconpath)
        self.configure(bg="#1e1e1e")

        self.logo = ctk.CTkImage(light_image=Image.open('ext_/src/img/logo.png'),
                                          dark_image=Image.open('ext_/src/img/logo.png'),
                                          size=(180, 100))

        self.logo = ctk.CTkLabel(self, text="", image=self.logo)
        self.logo.pack(pady=5)

        self.label_title = ctk.CTkLabel(self, text="LAUNCHER", font=("Courier", 24, "bold"), text_color="red")
        self.label_title.pack(pady=10)

        self.canvas = tk.Canvas(self, width=300, height=1, bg="gray", highlightthickness=0)
        self.canvas.pack(pady=20)


        self.button_start = ctk.CTkButton(self, text="Spiel Starten", command=self.open_server_selection)
        self.button_start.pack(pady=10)

        self.button_manage = ctk.CTkButton(self, text="Instanzen Verwalten", command=self.open_instanz_management)
        self.button_manage.pack(pady=10)

        self.button_exit = ctk.CTkButton(self, text="Beenden", fg_color="darkred", hover_color="black", command=self.quit)
        self.button_exit.pack(pady=10)

    def open_server_selection(self):
        ServerSelectionWindow(self)

    def open_instanz_management(self):
        InstanzManagementWindow(self)

class ServerSelectionWindow(ctk.CTkToplevel):
    def __init__(self, parent):
        super().__init__(parent)
        self.title("DOOM Instanz Starten")
        self.geometry("800x600")
        self.iconpath = ImageTk.PhotoImage(file="ext_/src/img/favicon.png")
        self.wm_iconbitmap()
        self.after(300, lambda: self.iconphoto(False, self.iconpath))
        self.transient(parent)
        self.grab_set()

        self.label = ctk.CTkLabel(self, text="DOOM Instanz Starten", font=("default", 20))
        self.label.pack(pady=10)

        self.label = ctk.CTkLabel(self,
                                  text="Hier sind alle Doom-Instanzen, welche du in diesem Launcher erstellt hast aufgelistet.\nWähle eine instanz aus, um diese zu Starten.",
                                  font=("default", 10), text_color="#737373")
        self.label.pack(pady=15)

        self.search_var = ctk.StringVar()
        self.search_entry = ctk.CTkEntry(self, textvariable=self.search_var, placeholder_text="Instanz suchen...")
        self.search_entry.pack(pady=5, padx=10, fill="x")
        self.search_entry.bind("<KeyRelease>", self.filter_instanzen)

        self.label = ctk.CTkLabel(self,
                                  text="Doom Instanz Suchen",
                                  font=("default", 10), text_color="#737373")
        self.label.pack(pady=0, padx=10, anchor="w")


        self.scrollable_frame = ctk.CTkScrollableFrame(self, width=300, height=100)
        self.scrollable_frame.pack(fill="both", expand=True, padx=10, pady=10)

        self.load_instanzen()

    def load_instanzen(self, filter_text=""):
        instanzen = lade_instanzen()
        for widget in self.scrollable_frame.winfo_children():
            widget.destroy()

        for name, data in instanzen.items():
            if filter_text.lower() in name.lower():
                frame = ctk.CTkFrame(self.scrollable_frame)
                frame.pack(fill="x", pady=5, padx=5)

                btn = ctk.CTkButton(frame, text=name, command=lambda n=name: self.start_instance(n), fg_color="gray22",
                                    hover_color="gray20")
                btn.pack(side="left", fill="x", expand=True, padx=5)
    def filter_instanzen(self, event):
        search_text = self.search_var.get()
        self.load_instanzen(search_text)

    def start_instance(self, name):
        starte_doom(name)
        self.destroy()

class InstanzManagementWindow(ctk.CTkToplevel):

    def __init__(self, parent):
        super().__init__(parent)

        self.title("DOOM Instanzen Verwalten")
        self.geometry("800x700")
        self.iconpath = ImageTk.PhotoImage(file="ext_/src/img/favicon.png")
        self.wm_iconbitmap()
        self.after(300, lambda: self.iconphoto(False, self.iconpath))
        self.transient(parent)
        self.grab_set()

        self.label = ctk.CTkLabel(self, text="DOOM Instanzen Erstellen", font=("default", 20))
        self.label.pack(pady=10)

        self.label = ctk.CTkLabel(self,
                                  text="Hier kannst du neue Instanzen erstellen, welche auf einer Custom wad Datei basieren.",
                                  font=("default", 10), text_color="#737373")
        self.label.pack(pady=15)

        self.main_frame = ctk.CTkFrame(self)
        self.main_frame.pack(fill="both", expand=True, padx=10, pady=10)

        self.frame_name = ctk.CTkFrame(self.main_frame)
        self.frame_name.pack(fill="x", pady=5, padx=10)

        self.label_name = ctk.CTkLabel(self.frame_name, text="Instanzname:", font=("default", 12))
        self.label_name.pack(side="left", padx=10, pady=5)

        self.entry_name = ctk.CTkEntry(self.frame_name, placeholder_text="Instanzname")
        self.entry_name.pack(side="left", fill="x", expand=True, padx=10, pady=5)

        self.frame_wad = ctk.CTkFrame(self.main_frame)
        self.frame_wad.pack(fill="x", pady=5, padx=10)

        self.label_wad = ctk.CTkLabel(self.frame_wad, text="WAD-Datei:", font=("default", 12))
        self.label_wad.pack(side="left", padx=10, pady=5)

        self.entry_wad = ctk.CTkEntry(self.frame_wad, placeholder_text="Pfad zur WAD-Datei")
        self.entry_wad.pack(side="left", fill="x", expand=True, padx=10, pady=5)

        self.button_select_wad = ctk.CTkButton(self.frame_wad, text="WAD auswählen", command=self.select_wad)
        self.button_select_wad.pack(side="left", padx=10, pady=5)

        self.frame_buttons = ctk.CTkFrame(self.main_frame)
        self.frame_buttons.pack(fill="x", pady=10, padx=10)

        self.button_save = ctk.CTkButton(self.frame_buttons, text="Instanz speichern", command=self.save_instance)
        self.button_save.pack(side="left", padx=10, pady=5)

        self.button_back = ctk.CTkButton(self.frame_buttons, text="Zurück", command=self.destroy)
        self.button_back.pack(side="left", padx=10, pady=5)

        self.canvas = tk.Canvas(self, width=600, height=1, bg="gray", highlightthickness=0)
        self.canvas.pack(pady=20)


        self.label = ctk.CTkLabel(self, text="DOOM Instanzen Löschen", font=("default", 20))
        self.label.pack(pady=10)

        self.label = ctk.CTkLabel(self,
                                  text="Hier sind alle Doom-Instanzen, welche du in diesem Launcher erstellt hast aufgelistet.\nWähle eine instanz aus, um diese zu Starten oder zu Löschen.",
                                  font=("default", 10), text_color="#737373")
        self.label.pack(pady=15)

        self.search_var = ctk.StringVar()
        self.search_entry = ctk.CTkEntry(self, textvariable=self.search_var, placeholder_text="Instanz suchen...")
        self.search_entry.pack(pady=5, padx=10, fill="x")
        self.search_entry.bind("<KeyRelease>", self.filter_instanzen)

        self.label = ctk.CTkLabel(self,
                                  text="Doom Instanz Suchen",
                                  font=("default", 10), text_color="#737373")
        self.label.pack(pady=0, padx=10, anchor="w")

        self.scrollable_frame = ctk.CTkScrollableFrame(self, width=300, height=100)
        self.scrollable_frame.pack(fill="both", expand=True, padx=10, pady=10)

        self.load_instanzen()

    def load_instanzen(self, filter_text=""):
        instanzen = lade_instanzen()
        for widget in self.scrollable_frame.winfo_children():
            widget.destroy()

        trash_icon = ctk.CTkImage(Image.open("ext_/src/img/trash_icon.png"), size=(20, 20))

        for name, data in instanzen.items():
            if filter_text.lower() in name.lower():
                frame = ctk.CTkFrame(self.scrollable_frame)
                frame.pack(fill="x", pady=5, padx=5)

                btn = ctk.CTkButton(frame, text=name, command=lambda n=name: self.start_instance(n),
                                    fg_color="gray22",
                                    hover_color="gray20")
                btn.pack(side="left", fill="x", expand=True, padx=5)

                del_btn = ctk.CTkButton(frame, text="", image=trash_icon, width=30, fg_color="red",
                                        hover_color="darkred",
                                        command=lambda n=name, i=data: self.delete_instance(i, n))
                del_btn.pack(side="right", padx=5)

    def delete_instance(self, instanz, name):
        msg = CTkMessagebox(title=name + " unwiederruflich löschen?",
                            message="Bist du dir wirklich sicher, dass du die Daten (inklusive Fortschritt) dieser Instanz wirklich unwiederruflich löschen möchtest?",
                            icon="warning", option_1="Abbrechen", option_2="Löschen")

        if msg.get() == "Löschen":
            if os.path.exists(instanz["save"]):
                shutil.rmtree(instanz["save"])
            if os.path.exists(instanz["wad"]):
                os.unlink(instanz["wad"])

            pop_instanz(name)

            CTkMessagebox(title=name + " unwiederruflich gelöscht!",
                                message="Instanz erfolgreich gelöscht!",
                                icon="info", option_1="Schließen")
        else:
            return None
        self.load_instanzen()

    def filter_instanzen(self, event):
        search_text = self.search_var.get()
        self.load_instanzen(search_text)

    def start_instance(self, name):
        starte_doom(name)
        self.destroy()

    def select_wad(self):
        global WAD_PATH
        wad_path_sel = filedialog.askopenfilename(filetypes=[("WAD files", "*.wad")])
        if wad_path_sel:
            self.entry_wad.delete(0, ctk.END)
            self.entry_wad.insert(0, wad_path_sel)
            WAD_PATH = os.path.join(WAD_DIR, str(uuid.uuid4())+".wad")

            if not os.path.exists(WAD_DIR):
                os.makedirs(WAD_DIR)

            shutil.copy2(wad_path_sel, WAD_PATH)

    def save_instance(self):
        global WAD_PATH
        instanz_existiert = False

        filter_text = self.entry_name.get()

        instanzen = lade_instanzen()

        for name, data in instanzen.items():
            if filter_text.lower() == name.lower():
                instanz_existiert=True

        if instanz_existiert:
            msg = CTkMessagebox(title="Diese Instanz existiert schon!",
                                message="Eine Instanz mit dem Namen existiert schon.",
                                icon="warning", option_1="Ok")

            if msg.get() == "Ok":
                self.load_instanzen()
            else:
                self.load_instanzen()
            return None

        if not filter_text or not WAD_PATH:
            messagebox.showerror("Fehler", "Bitte fülle alle Felder aus!")
            return

        save_dir = os.path.join(SAVE_DIR, str(uuid.uuid4()))
        if not os.path.exists(save_dir):
            os.makedirs(save_dir)

        if not os.path.isfile(WAD_PATH):
            messagebox.showerror("Fehler", "WAD-Datei nicht gefunden!")
            return

        speichere_instanz(filter_text, WAD_PATH, save_dir)
        self.destroy()

if __name__ == "__main__":
    log_info("Generating Data")
    if not os.path.exists(WAD_DIR):
        os.makedirs(WAD_DIR)
    if not os.path.exists(SAVE_DIR):
        os.makedirs(SAVE_DIR)

        
    log_info("[FRONTEND] Loading Task...")

    app = MainApp()
    log_info("[FRONTEND] Start GUI")

    app.mainloop()